var flickerCode = '0301091B0301091B0301091B0301091B0301091B';
var opticalDataAsReinerSct = true;

function _StartTanBeamer() {
    aTanBeamer = new TanFlicker(100);
    aTanBeamer.prepare(
        document.getElementById("ledSync"),
        document.getElementById("led1"),
        document.getElementById("led2"),
        document.getElementById("led3"),
        document.getElementById("led4")
    );
    startFlicker();
    initializeSpeedSlider();
    initializeSizeSlider();
}

function startFlicker() {
    aTanBeamer.start(flickerCode, opticalDataAsReinerSct);
}

function stopFlicker() {
    aTanBeamer.stopFlicker();
}

function initializeSpeedSlider() {
    var flickerSpeed = document.getElementById("flickerSpeed");
    noUiSlider.create(flickerSpeed, {
        start: 10,
        step: 1,
        connect: [true, false],
        orientation: "horizontal",
        range: {
            min: 1,
            max: 35
        },
        format: {
            to: function (value) {
                return value;
            },
            from: function (value) {
                return value;
            }
        }
    });

    flickerSpeed.noUiSlider.on("update", function (values) {
        var newValue = values[0];
        aTanBeamer.stopFlicker();
        aTanBeamer.changeInterval(1000 / newValue);
        aTanBeamer.start(flickerCode, opticalDataAsReinerSct);

        var currentSpeedPercentage = Math.floor((newValue / 35) * 100);
        var label = $('label[for="flickerSpeed"]')[0];
        label.innerHTML = 'Flicker-Code Geschwindigkeit - ' + currentSpeedPercentage + '%'
    });
}

function initializeSizeSlider() {
    // initialize width slider
    var flickerSize = document.getElementById("flickerSize");
    noUiSlider.create(flickerSize, {
        start: 210,
        step: 5,
        connect: [true, false],
        orientation: "horizontal",
        range: {
            min: 210,
            max: 330
        },
        format: {
            to: function (value) {
                return value;
            },
            from: function (value) {
                return value;
            }
        }
    });
    flickerSize.noUiSlider.on("update", function (values) {
        var newValue = values[0];

        flickerItems = document.getElementById("flickerItems");
        $("#flickerItems").width(newValue);
        $("#flickerItems").height(newValue / 2);

        var currentSizePercentage = Math.floor(((newValue - 210) * 100) / (330 - 210));
        var label = $('label[for="flickerSize"]')[0];
        label.innerHTML = 'Flicker-Code Größe - ' + currentSizePercentage + '%'
    });
}

var TanFlicker = function (interval) {
    this._interval = interval;
    this.symbols = {};
    this.symbols['0'] = [0, 0, 0, 0];
    this.symbols['1'] = [1, 0, 0, 0];
    this.symbols['2'] = [0, 1, 0, 0];
    this.symbols['3'] = [1, 1, 0, 0];
    this.symbols['4'] = [0, 0, 1, 0];
    this.symbols['5'] = [1, 0, 1, 0];
    this.symbols['6'] = [0, 1, 1, 0];
    this.symbols['7'] = [1, 1, 1, 0];
    this.symbols['8'] = [0, 0, 0, 1];
    this.symbols['9'] = [1, 0, 0, 1];
    this.symbols['A'] = [0, 1, 0, 1];
    this.symbols['B'] = [1, 1, 0, 1];
    this.symbols['C'] = [0, 0, 1, 1];
    this.symbols['D'] = [1, 0, 1, 1];
    this.symbols['E'] = [0, 1, 1, 1];
    this.symbols['F'] = [1, 1, 1, 1];
};

TanFlicker.prototype.prepare = function (ledSync, led1, led2, led3, led4) {
    this.refreshLeds = function (data, sync) {
        ledSync.className = (sync === 1) ? "ledOn" : "ledOff";

        var leds = [led1, led2, led3, led4];

        for (var i = 0; i < leds.length; i++) {
            if (data[i] === 1) {
                leds[i].className = "ledOn";
            } else {
                leds[i].className = "ledOff";
            }
        }
    };

    this.refreshLeds([0, 0, 0, 0], 0);
    this._timer = null;

    this.initializeDataBits = function (data, symbols) {
        // synchronization identifier must be added AFTER data is sorted for REINER SCT based flicker codes
        var _data = this.isReinerSctFlicker ? data : '0FFF' + data;
        var dataBits = [];
        for (var i = 0; i < _data.length; i += 2) {
            dataBits[i] = symbols[_data[i + 1]];
            dataBits[i + 1] = symbols[_data[i]];
        }
        if (this.isReinerSctFlicker) {
            // prepend synchronization identifier 0FF
            dataBits.unshift([0, 0, 0, 0], [1, 1, 1, 1], [1, 1, 1, 1]);
        }
        return dataBits;
    }

    this.toLineStart = function () {
        this.offset = 0;
        this.sync = 1;
    };

    this._setup = function (tanCode) {
        function toHex(n, minlen) {
            var s = n.toString(16).toUpperCase();
            while (s.length < minlen) {
                s = '0' + s;
            }
            return s;
        }

        function querSum(n) {
            var q = 0;
            while (n !== 0) {
                q += n % 10;
                n = Math.floor(n / 10);
            }
            return q;
        }

        function getContent(_data) {
            i = 0;
            content = '';

            len = parseInt(_data.slice(0, 2), 16);
            i += 2;
            while (i < _data.length - 2) {
                /* skip bcd identifier */
                i += 1;
                /* parse length */
                len = parseInt(_data.slice(i, i + 1), 16);
                i += 1;
                content += _data.slice(i, i + len * 2);
                i += len * 2;
            }
            return content;
        }

        this.data = tanCode.toUpperCase();

        // Luhn algorithm must be skipped for REINER SCT based flicker codes
        if (!this.isReinerSctFlicker) {
            var len = this.data.length / 2 - 1;
            this.data = toHex(len, 2) + this.data.substr(2);
            var luhn = 0;
            var content = getContent(this.data);
            for (var i = 0; i < content.length; i += 2) {
                luhn += parseInt(content[i], 16) + querSum(2 * parseInt(content[i + 1], 16));
            }
            luhn = (10 - (luhn % 10)) % 10;
            this.data = this.data.substr(0, this.data.length - 2) + toHex(luhn, 1) + this.data.substr(this.data.length - 1);

            var xorSum = 0;
            for (var i = 0; i < this.data.length - 2; i++) {
                xorSum ^= parseInt(this.data[i], 16);
            }
            this.data = this.data.substr(0, this.data.length - 1) + toHex(xorSum, 1);
        }
        this.dataBits = this.initializeDataBits(this.data, this.symbols);
        this.toLineStart();
    }
};

TanFlicker.prototype.step = function () {
    this.refreshLeds(this.dataBits[this.offset], this.sync--);
    if (this.sync < 0) {
        this.sync = 1;
        this.offset += 1;
        if (this.offset > this.dataBits.length - 1) {
            this.toLineStart();
        }
    }
};

TanFlicker.prototype.stopFlicker = function () {
    if (this._timer) {
        window.clearInterval(this._timer);
        this._timer = null;
        this.refreshLeds([0, 0, 0, 0], 0);
    }
};

/**
 * Start showing the flicker code
 * @param {string} tanCode the optical data string
 * @param {boolean} opticalDataAsReinerSct Whether the optical data should be processed with the Reiner SCT flicker algorithm.
 */
TanFlicker.prototype.start = function (tanCode, opticalDataAsReinerSct) {
    this.isReinerSctFlicker = opticalDataAsReinerSct;
    this._setup(tanCode);
    var tanFlicker = this;
    // If the timer is still active, stop it before starting again
    if (this._timer) {
        this.stopFlicker();
    }
    this._timer = window.setInterval(function () {
        tanFlicker.step();
    }, this._interval);
};

/**
 * Change interval
 * @param {number} newInterval new value
 */
TanFlicker.prototype.changeInterval = function (newInterval) {
    this._interval = newInterval;
};

